/*
 * Decompiled with CFR 0.152.
 */
package com.james.tinkerscalibration.modifiers;

import com.james.tinkerscalibration.Utils;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.TooltipFlag;
import net.minecraftforge.registries.RegistryObject;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.common.TinkerEffect;
import slimeknights.tconstruct.common.TinkerTags;
import slimeknights.tconstruct.library.modifiers.Modifier;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.modifiers.TinkerHooks;
import slimeknights.tconstruct.library.modifiers.hook.ConditionalStatModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.ProjectileLaunchModifierHook;
import slimeknights.tconstruct.library.modifiers.util.ModifierHookMap;
import slimeknights.tconstruct.library.tools.context.ToolAttackContext;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;
import slimeknights.tconstruct.library.tools.nbt.NamespacedNBT;
import slimeknights.tconstruct.library.tools.stat.FloatToolStat;
import slimeknights.tconstruct.library.tools.stat.ToolStats;
import slimeknights.tconstruct.library.utils.TooltipKey;

public class CriticalSpeedModifier
extends Modifier
implements ProjectileLaunchModifierHook,
ConditionalStatModifierHook {
    private static final Component SPEED = TConstruct.makeTranslation((String)"modifier", (String)"criticalhit.speed");

    protected void registerHooks(ModifierHookMap.Builder hookBuilder) {
        hookBuilder.addHook((Object)this, TinkerHooks.CONDITIONAL_STAT, TinkerHooks.PROJECTILE_LAUNCH);
    }

    private static float getBonus(LivingEntity living, RegistryObject<? extends TinkerEffect> effect, int level, float scale) {
        int effectLevel = ((TinkerEffect)effect.get()).getLevel(living) + 1;
        return (float)(level * effectLevel) / scale;
    }

    public int afterEntityHit(IToolStackView tool, int level, ToolAttackContext context, float damageDealt) {
        if (!context.isExtraAttack() && context.isCritical()) {
            LivingEntity attacker = context.getAttacker();
            int effectLevel = Math.min(7, ((TinkerEffect)Utils.criticalspeedEffect.get()).getLevel(attacker) + 1);
            ((TinkerEffect)Utils.criticalspeedEffect.get()).apply(attacker, 100, effectLevel, false);
        }
        return 0;
    }

    public void onProjectileLaunch(IToolStackView tool, ModifierEntry modifier, LivingEntity shooter, Projectile projectile, @Nullable AbstractArrow arrow, NamespacedNBT persistentData, boolean primary) {
        if (primary && arrow.m_36792_()) {
            int effectLevel = Math.min(15, ((TinkerEffect)Utils.criticalspeedEffect.get()).getLevel(shooter) + 1);
            ((TinkerEffect)Utils.criticalspeedEffect.get()).apply(shooter, 100, effectLevel, false);
        }
    }

    public float modifyStat(IToolStackView tool, ModifierEntry modifier, LivingEntity living, FloatToolStat stat, float baseValue, float multiplier) {
        if (stat == ToolStats.ATTACK_SPEED) {
            return baseValue * (1.0f + CriticalSpeedModifier.getBonus(living, Utils.criticalspeedEffect, modifier.getLevel(), 16.0f));
        }
        if (stat == ToolStats.DRAW_SPEED) {
            return baseValue * (1.0f + CriticalSpeedModifier.getBonus(living, Utils.criticalspeedEffect, modifier.getLevel(), 16.0f));
        }
        return baseValue;
    }

    public void addInformation(IToolStackView tool, int level, @Nullable Player player, List<Component> tooltip, TooltipKey key, TooltipFlag flag) {
        float bonus;
        boolean harvest = tool.hasTag(TinkerTags.Items.HARVEST);
        if ((harvest || tool.hasTag(TinkerTags.Items.RANGED)) && player != null && key == TooltipKey.SHIFT && (bonus = CriticalSpeedModifier.getBonus((LivingEntity)player, Utils.criticalspeedEffect, level, 16.0f)) > 0.0f) {
            this.addPercentTooltip(SPEED, bonus, tooltip);
        }
    }
}

